# -*- coding: utf-8 -*-
"""
Auxiliary functions for cyclic_analysis.py

Created on Wed Apr 28 09:23:30 2021

@author: s168562
"""


# def read_data(filename, filepath, headerline, outpath, nr_cycles, max_strain, 
#               min_strain, no_outpath = False):
#     ''' Reads file data, prepares output folder and extracts header information
#     from the input file'''
#     ### import packages
#     import pandas as pd
#     import os # for file paths
    
#     ### Output
#     outfolder = filename[:-4] # eliminate the extension
#     outpathfull = os.path.join(outpath,outfolder)
#     if not no_outpath:
#         if not os.path.exists(outpathfull):
#             os.makedirs(outpathfull)
    
#     ### Read data
#     fullpath = os.path.join(filepath,filename)
#     # straining_df = pd.read_csv(fullpath, sep = "\t", header = 111, index_col=0) # somehow doesn't interpret the row numbers correctly
#     straining_df = pd.read_csv(fullpath, sep = "\s+", skiprows = headerline,
#                                header = None, index_col=False, engine = 'python') # python engine because trailing spaces not supported by c
#     # straining_df.columns.values[0] = "Time" #Get rid of semicolon in name;
#     straining_df.columns = ["Time", "Position", "Force", "Direction", 
#                                    "Cycles_done", "Cycle_line", "Switch",
#                                    "R-Time", "Resist_A"]
    
#     ### Extract file details from txt file
#     search_dic = {'Initial Value=': 'Rini',
#                   'Sample ID=':'sampleID',
#                   'Substrate.Material=':'mat',
#                   'Test length=':'length',
#                   'Sample.Width=':'width',
#                   'Printed line.Width=':'linewidth',
#                   }
    
#     value_dic = {}
    
#     linenr = 0
#     with open(fullpath, 'rt') as headerfile:
#         #header = [next(headerfile) for line in range(100)]
#         while linenr < 100:
#             for line in headerfile:
#                 linenr += 1
#                 for key, value in search_dic.items():
#                     if line.find(key) != -1: # Rini
#                         idx = line.find(key) + len(key)
#                         pvalue = line[idx:-1] # Parameter value, Exclude \n
#                         value_dic[value] = pvalue
    
#     Rini = float(value_dic['Rini'])
#     sampleID = value_dic['sampleID']
#     mat = value_dic['mat']
#     length = float(value_dic['length'])
#     width = float(value_dic['width'])
#     linewidth = float(value_dic['linewidth'])
#     return outpathfull, straining_df, Rini, sampleID, mat, length, width, linewidth

def read_data(filename, filepath, headerline, outpath, nr_cycles, max_strain, 
              min_strain, no_outpath = False):
    ''' Reads file data, prepares output folder and extracts header information
    from the input file'''
    ### import packages
    import pandas as pd
    import os # for file paths
    
    ### Output
    outfolder = filename[:-4] # eliminate the extension
    outpathfull = os.path.join(outpath,outfolder)
    if not no_outpath:
        if not os.path.exists(outpathfull):
            os.makedirs(outpathfull)
    
    ### Read data
    fullpath = os.path.join(filepath,filename)
    # straining_df = pd.read_csv(fullpath, sep = "\t", header = 111, index_col=0) # somehow doesn't interpret the row numbers correctly
    straining_df = pd.read_csv(fullpath, sep = "\s+", skiprows = headerline,
                               header = None, index_col=False, engine = 'python') # python engine because trailing spaces not supported by c
    # straining_df.columns.values[0] = "Time" #Get rid of semicolon in name;
    straining_df.columns = ["Time", "Position", "Force", "Direction", 
                                   "Cycles_done", "Cycle_line", "Switch",
                                   "R-Time", "Resist_A"]
    
    ### Extract file details from txt file
    search_dic = {'Initial Value=': 'Rini',
                  'Sample ID=':'sampleID',
                  'Substrate.Material=':'mat',
                  'Test length=':'length',
                  'Sample.Width=':'width',
                  'Printed line.Width=':'linewidth',
                  }
    
    value_dic = {}
    
    linenr = 0
    with open(fullpath, 'rt') as headerfile:
        #header = [next(headerfile) for line in range(100)]
        while linenr < 100:
            for line in headerfile:
                linenr += 1
                for key, value in search_dic.items():
                    if line.find(key) != -1: # Rini
                        idx = line.find(key) + len(key)
                        pvalue = line[idx:-1] # Parameter value, Exclude \n
                        value_dic[value] = pvalue
    
    Rini = float(value_dic['Rini'])
    sampleID = value_dic['sampleID']
    mat = value_dic['mat']
    length = float(value_dic['length'])
    width = float(value_dic['width'])
    linewidth = float(value_dic['linewidth'])
    return straining_df, Rini, sampleID, mat, length, width, linewidth, outpathfull
    
    
    
def calc_cycles(straining_df, nr_cycles, length, max_strain, min_strain, Rini,
                remove_first_point):
    ''' Perform calculations on the cyclic data to extract the min and max 
    resistance at the minimum strain (defined as the last data point before
    the strain starts to increase) and at the maximum strain (defined as the 
    first data point of the upper plateau). Those data points
    are also averaged over 10 and 100 cycles. Also extracts the
    resistance at 1% and 19% strain.'''   
    # Import packages
    import pandas as pd
    import numpy as np
    
      # # somehow missing 2 values in the min range, but this should be the correct method.
    # # Pragmatically, I found an alternative method (see below)
    # straining_df['Strain'] = straining_df['Position']/length 
    # min_strain = [0, 0.008, 0.01, 0.012, 0.014, 0.016, 0.018, 0.02, 0.022, 0.024,
    #               0.026, 0.029, 0.031, 0.033, 0.036, 0.038, 0.041, 0.043, 0.046,
    #               0.049, 0.052, 0.055, 0.058, 0.061, 0.064, 0.067, 0.071, 0.073,
    #               0.076, 0.081, 0.084, 0.087, 0.091, 0.095, 0.099, 0.104, 0.107,
    #               0.111, 0.117, 0.119, 0.124, 0.129, 0.133, 0.138, 0.144, 0.148,
    #               0.153, 0.159, 0.164, 0.168]
    # max_strain = np.linspace(0.02, 1, 50)
    
    # straining_df['Min_pos'] = False # Start of cycle (last point valley)
    # straining_df['Max_pos'] = False # start of top plateau 
    # cycle = 0
    
    # # somehow missing 2 values in the min range, but this should be the correct method.
    # # Pragmatically, I found an alternative method (see below)
    # for i in range(len(straining_df)):
    #     if cycle < 50:
    #         if (round(straining_df['Strain'].iloc[i], 3) <= min_strain[cycle]):
    #             if round(straining_df['Strain'].iloc[i+1],3) > min_strain[cycle]:
    #                 straining_df['Min_pos'][i] = True
    #                 print(cycle)
    #                 print(i)
    #         elif (round(straining_df['Strain'].iloc[i], 3) < max_strain[cycle]):
    #             if round(straining_df['Strain'].iloc[i+1], 3) >= max_strain[cycle]:
    #                 straining_df['Max_pos'][i+1] = True
    #                 # print(cycle)
    #                 # print(i)
    #                 cycle += 1
            
    # # Check correctness by checking the number of positions captured
    # print(sum(straining_df['Min_pos']))
    # print(sum(straining_df['Max_pos']))
    
    # pragmatic alternative
    straining_df['Strain'] = straining_df['Position']/length 
    min_cycles_done = np.linspace(0, 49, 50)
    max_cycles_done= np.linspace(0.40, 49.40, 50)
    
    straining_df['Min_pos'] = False # Start of cycle (last point valley)
    straining_df['Max_pos'] = False # start of top plateau 
    cycle = 0
    
    # somehow missing 2 values in the min range, but this should be the correct method.
    # Pragmatically, I found an alternative method (see below)
    for i in range(1,len(straining_df)):
        if cycle < 50:
            if (round(straining_df['Cycles_done'].iloc[i-1], 2) < min_cycles_done[cycle]):
                if round(straining_df['Cycles_done'].iloc[i],2) == min_cycles_done[cycle]:
                    straining_df['Min_pos'][i] = True
                    # print(cycle)
                    # print(i)
            elif (round(straining_df['Cycles_done'].iloc[i-1], 2) < max_cycles_done[cycle]):
                if round(straining_df['Cycles_done'].iloc[i], 2) == max_cycles_done[cycle]:
                    straining_df['Max_pos'][i] = True
                    # print(cycle)
                    # print(i)
                    cycle += 1
            
    # Check correctness by checking the number of positions captured
    print(sum(straining_df['Min_pos']))
    print(sum(straining_df['Max_pos']))
    
    # Save the relevant data points at 0/1/19/20 % strain for calculations
    # Normalize them by Rini
    strain_series_max = straining_df['Resist_A'][straining_df['Max_pos']]
    strain_series_min = straining_df['Resist_A'][straining_df['Min_pos']]


    return (straining_df, strain_series_max, 
        strain_series_max2, strain_series_min, strain_series_min2)

